#include "DataSphere.h"

namespace DataTypes
{

DataSphere::DataSphere()
{
}

DataSphere::DataSphere(int bodyid, float radius, Vector3f position,Vector3f rotation,int materialid,float mass, Vector3f linearvelocity, Vector3f angularvelocity): DataBody(bodyid, materialid, mass,linearvelocity, angularvelocity)
{
	this->radius = radius;
	this->position = position;
	this->rotation = rotation;
}

DataSphere::~DataSphere()
{
}

float DataSphere::GetRadius()
{
	return radius;
}
Vector3f DataSphere::GetPosition()
{
	return position;
}

Vector3f DataSphere::GetRotation()
{
	return rotation;
}


void DataSphere::SetRadius(float value)
{
	this->radius = value;
}

void DataSphere::SetPosition(Vector3f value)
{
	this->position = value;
}

void DataSphere::SetRotation(Vector3f value)
{
	this->rotation = value;
}

string DataSphere::ToString()
{
	stringstream rad;
	rad<< this->radius;
	stringstream id,material, mass;
	id<< this->GetBodyId();
	material<< this->GetMaterialId();
	mass<<this->GetMass();
	return "<Body Type=\"Sphere\"><Body_id>"+id.str()+"</Body_id><Material>"+ material.str()+"</Material><Mass>"+mass.str()+"</Mass><Radius>"+rad.str()+"</Radius>"
	+ position.ToString("Position_X","Position_Y","Position_Z")+
	rotation.ToString("Rotation_X","Rotation_Y","Rotation_Z")+this->GetLinearVelocity().ToString("Linear_Velocity_X","Linear_Velocity_Y","Linear_Velocity_Z")+this->GetAngularVelocity().ToString("Angular_Velocity_X","Angular_Velocity_Y","Angular_Velocity_Z")+"</Body>";
}


}
